﻿using System;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace VIRP_WEB.Custom.EFR
{
    public partial class BioContactFollowups : EfrBasePage
    {
        protected override void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                ((Label)Master.FindControl("EfrPageTitle")).Text = "My Tasks > Referrals > Follow Ups";
                HiddenFieldClearFlag.Value = "0";
            }

            SetupCommonDataSourceParameters();

            // Added for 508 compliance with GridView column headers and footer
            Page.ClientScript.RegisterStartupScript(GetType(), "UpdateGridView", "UpdateGridView('" + GridViewReferralFollowUps.ClientID + "');", true);
        }

        private void SetupCommonDataSourceParameters()
        {
            ObjectDataSourceFollowUps.SelectParameters["CURRENT_USER"].DefaultValue = CurrentUser;            
            ObjectDataSourceFollowUps.SelectParameters["CURRENT_REGISTRY_ID"].DefaultValue = CurrentRegistryId.ToString();
        }

        protected void ButtonClear_Click(object sender, EventArgs e)
        {
            TextBoxSearchCriteria.Text = String.Empty;
            HiddenFieldClearFlag.Value = "1";
        }

        protected void ButtonOK_Clear(object sender, EventArgs e)
        {
            GridViewReferralFollowUps.PageIndex = 0;
            HiddenFieldClearFlag.Value = "0";

            ObjectDataSourceFollowUps.SelectParameters["PATIENT_LAST_NAME"].DefaultValue = TextBoxSearchCriteria.Text.Trim();
        }

        public void FollowUps_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName == "Details")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewReferralFollowUps.SelectedIndex = index;
                
                Label fUpType = GridViewReferralFollowUps.SelectedRow.FindControl("LabelFollowupType") as Label;
                if (fUpType != null)
                {
                    if (fUpType.Text.Equals("Biomonitoring"))
                    {
                        int id = int.Parse(GridViewReferralFollowUps.SelectedDataKey["ReferralId"].ToString());
                        Response.Redirect(string.Format("~/Custom/EFR/Referrals/Referral.aspx?referralId={0}&statusId=9999", id));
                    }
                    else if (fUpType.Text.Equals("Contact"))
                    {
                        int referralId = int.Parse(GridViewReferralFollowUps.SelectedDataKey["ReferralId"].ToString());
                        int contactId = int.Parse(GridViewReferralFollowUps.SelectedDataKey["ContactId"].ToString());

                        Response.Redirect(string.Format("ReferralContact.aspx?referralId={0}&contactId={1}", referralId, contactId));
                    }
                }
            }
        }
    }
}
